/*
 * Decompiled with CFR 0.152.
 */
package lotr.common.entity.npc;

import lotr.common.LOTRAchievement;
import lotr.common.LOTRFoods;
import lotr.common.LOTRMod;
import lotr.common.entity.ai.LOTREntityAIAttackOnCollide;
import lotr.common.entity.ai.LOTREntityAIDrink;
import lotr.common.entity.ai.LOTREntityAIEat;
import lotr.common.entity.ai.LOTREntityAIFollowHiringPlayer;
import lotr.common.entity.ai.LOTREntityAIHiredRemainStill;
import lotr.common.entity.ai.LOTREntityAINearestAttackableTargetBasic;
import lotr.common.entity.animal.LOTREntityRabbit;
import lotr.common.entity.npc.LOTREntityNPC;
import lotr.common.entity.npc.LOTRNames;
import lotr.common.fac.LOTRFaction;
import lotr.common.item.LOTRMaterial;
import lotr.common.quest.LOTRMiniQuest;
import lotr.common.quest.LOTRMiniQuestFactory;
import net.minecraft.entity.EntityCreature;
import net.minecraft.entity.EntityLiving;
import net.minecraft.entity.IEntityLivingData;
import net.minecraft.entity.SharedMonsterAttributes;
import net.minecraft.entity.ai.EntityAIBase;
import net.minecraft.entity.ai.EntityAILookIdle;
import net.minecraft.entity.ai.EntityAISwimming;
import net.minecraft.entity.ai.EntityAIWander;
import net.minecraft.entity.ai.EntityAIWatchClosest;
import net.minecraft.entity.ai.EntityAIWatchClosest2;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Items;
import net.minecraft.item.ItemArmor;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.world.World;

public class LOTREntityHalfTroll
extends LOTREntityNPC {
    public LOTREntityHalfTroll(World world) {
        super(world);
        this.func_70105_a(1.0f, 2.4f);
        this.func_70661_as().func_75491_a(true);
        this.field_70714_bg.func_75776_a(0, (EntityAIBase)new EntityAISwimming((EntityLiving)this));
        this.field_70714_bg.func_75776_a(1, (EntityAIBase)new LOTREntityAIHiredRemainStill(this));
        this.field_70714_bg.func_75776_a(2, this.createHalfTrollAttackAI());
        this.field_70714_bg.func_75776_a(3, (EntityAIBase)new LOTREntityAIFollowHiringPlayer(this));
        this.field_70714_bg.func_75776_a(4, (EntityAIBase)new EntityAIWander((EntityCreature)this, 1.0));
        this.field_70714_bg.func_75776_a(5, (EntityAIBase)new LOTREntityAIEat(this, LOTRFoods.HALF_TROLL, 6000));
        this.field_70714_bg.func_75776_a(5, (EntityAIBase)new LOTREntityAIDrink(this, LOTRFoods.HALF_TROLL_DRINK, 6000));
        this.field_70714_bg.func_75776_a(6, (EntityAIBase)new EntityAIWatchClosest2((EntityLiving)this, EntityPlayer.class, 8.0f, 0.02f));
        this.field_70714_bg.func_75776_a(6, (EntityAIBase)new EntityAIWatchClosest2((EntityLiving)this, LOTREntityNPC.class, 5.0f, 0.02f));
        this.field_70714_bg.func_75776_a(7, (EntityAIBase)new EntityAIWatchClosest((EntityLiving)this, EntityLiving.class, 8.0f, 0.02f));
        this.field_70714_bg.func_75776_a(8, (EntityAIBase)new EntityAILookIdle((EntityLiving)this));
        int target = this.addTargetTasks(true);
        this.field_70715_bh.func_75776_a(target + 1, (EntityAIBase)new LOTREntityAINearestAttackableTargetBasic(this, LOTREntityRabbit.class, 1000, false));
        this.spawnsInDarkness = true;
    }

    public EntityAIBase createHalfTrollAttackAI() {
        return new LOTREntityAIAttackOnCollide(this, 1.4, false);
    }

    @Override
    public void func_70088_a() {
        super.func_70088_a();
        this.field_70180_af.func_75682_a(17, (Object)0);
    }

    @Override
    public void setupNPCName() {
        this.familyInfo.setName(LOTRNames.getOrcName(this.field_70146_Z));
    }

    private boolean getHalfTrollModelFlag(int part) {
        byte i = this.field_70180_af.func_75683_a(17);
        return (i & 1 << part) != 0;
    }

    private void setHalfTrollModelFlag(int part, boolean flag) {
        int i = this.field_70180_af.func_75683_a(17);
        int pow2 = 1 << part;
        i = flag ? (i = i | pow2) : (i = i & ~pow2);
        this.field_70180_af.func_75692_b(17, (Object)((byte)i));
    }

    public boolean hasMohawk() {
        return this.getHalfTrollModelFlag(1);
    }

    public void setHasMohawk(boolean flag) {
        this.setHalfTrollModelFlag(1, flag);
    }

    public boolean hasHorns() {
        return this.getHalfTrollModelFlag(2);
    }

    public void setHasHorns(boolean flag) {
        this.setHalfTrollModelFlag(2, flag);
    }

    public boolean hasFullHorns() {
        return this.getHalfTrollModelFlag(3);
    }

    public void setHasFullHorns(boolean flag) {
        this.setHalfTrollModelFlag(3, flag);
    }

    @Override
    protected void func_110147_ax() {
        super.func_110147_ax();
        this.func_110148_a(SharedMonsterAttributes.field_111267_a).func_111128_a(35.0);
        this.func_110148_a(SharedMonsterAttributes.field_111265_b).func_111128_a(24.0);
        this.func_110148_a(SharedMonsterAttributes.field_111263_d).func_111128_a(0.2);
        this.func_110148_a(npcAttackDamage).func_111128_a(6.0);
        this.func_110148_a(horseAttackSpeed).func_111128_a(1.5);
    }

    @Override
    public IEntityLivingData func_110161_a(IEntityLivingData data) {
        data = super.func_110161_a(data);
        this.setHasMohawk(this.field_70146_Z.nextBoolean());
        if (this.field_70146_Z.nextBoolean()) {
            this.setHasHorns(true);
            this.setHasFullHorns(this.field_70146_Z.nextBoolean());
        }
        return data;
    }

    @Override
    protected void onAttackModeChange(LOTREntityNPC.AttackMode mode, boolean mounted) {
        if (mode == LOTREntityNPC.AttackMode.IDLE) {
            this.func_70062_b(0, this.npcItemsInv.getIdleItem());
        } else {
            this.func_70062_b(0, this.npcItemsInv.getMeleeWeapon());
        }
    }

    @Override
    public LOTRFaction getFaction() {
        return LOTRFaction.HALF_TROLL;
    }

    @Override
    public String getNPCName() {
        return this.familyInfo.getName();
    }

    @Override
    public void func_70014_b(NBTTagCompound nbt) {
        super.func_70014_b(nbt);
        nbt.func_74757_a("Mohawk", this.hasMohawk());
        nbt.func_74757_a("Horns", this.hasHorns());
        nbt.func_74757_a("HornsFull", this.hasFullHorns());
    }

    @Override
    public void func_70037_a(NBTTagCompound nbt) {
        super.func_70037_a(nbt);
        this.setHasMohawk(nbt.func_74767_n("Mohawk"));
        this.setHasHorns(nbt.func_74767_n("Horns"));
        this.setHasFullHorns(nbt.func_74767_n("HornsFull"));
        if (nbt.func_74764_b("HalfTrollName")) {
            this.familyInfo.setName(nbt.func_74779_i("HalfTrollName"));
        }
    }

    @Override
    protected void func_70628_a(boolean flag, int i) {
        super.func_70628_a(flag, i);
        int flesh = this.field_70146_Z.nextInt(3) + this.field_70146_Z.nextInt(i + 1);
        for (int l = 0; l < flesh; ++l) {
            this.func_145779_a(Items.field_151078_bh, 1);
        }
        int bones = this.field_70146_Z.nextInt(2) + this.field_70146_Z.nextInt(i + 1);
        for (int l = 0; l < bones; ++l) {
            this.func_145779_a(LOTRMod.trollBone, 1);
        }
    }

    @Override
    public float getAlignmentBonus() {
        return 1.0f;
    }

    @Override
    protected LOTRAchievement getKillAchievement() {
        return LOTRAchievement.killHalfTroll;
    }

    protected String func_70639_aQ() {
        return "lotr:halfTroll.say";
    }

    protected String func_70621_aR() {
        return "lotr:halfTroll.hurt";
    }

    protected String func_70673_aS() {
        return "lotr:halfTroll.death";
    }

    @Override
    public String getSpeechBank(EntityPlayer entityplayer) {
        if (this.isFriendlyAndAligned(entityplayer)) {
            if (this.hiredNPCInfo.getHiringPlayer() == entityplayer) {
                return "halfTroll/halfTroll/hired";
            }
            return "halfTroll/halfTroll/friendly";
        }
        return "halfTroll/halfTroll/hostile";
    }

    @Override
    public LOTRMiniQuest createMiniQuest() {
        return LOTRMiniQuestFactory.HALF_TROLL.createQuest(this);
    }

    @Override
    public LOTRMiniQuestFactory getBountyHelpSpeechDir() {
        return LOTRMiniQuestFactory.HALF_TROLL;
    }

    @Override
    public boolean canReEquipHired(int slot, ItemStack itemstack) {
        if (slot == 0 || slot == 1 || slot == 2 || slot == 3) {
            return itemstack != null && itemstack.func_77973_b() instanceof ItemArmor && ((ItemArmor)itemstack.func_77973_b()).func_82812_d() == LOTRMaterial.HALF_TROLL.toArmorMaterial();
        }
        return super.canReEquipHired(slot, itemstack);
    }
}

